clear();
clc();
close all;                              %Plots schlieen

%INITIALISIERUNG-------------------------------------------------------------------
syms a b c d e f g h i j k l m n o p q r s t u v w x y z;   %Initialisierung der Variablennamen -> muss unbedingt vor der KOnfiguration stehen

%KONFIGURATION---------------------------------------------------------------------
vVARIABLEN          = [x, y];
symNLGS(1,1)        = 2*x + 4*y;        %Eingabe der ersten Zeile des Nichtlinearen Gleichungssystems
symNLGS(2,1)        = 4*x + 8*y^3;      %Eingabe der zweiten Zeile des Nichtlinearen Gleichungssystems
vSTARTVEKTOR(1)     = 4;
vSTARTVEKTOR(2)     = 2;
ik                  = 4;                %Anzahl Iterationen

%INITIALISIERUNG-------------------------------------------------------------------
NLGS                = arrayfun(@char, symNLGS, 'uniform', 0);
vSTARTVEKTOR        = vSTARTVEKTOR';
X(1,1)              = {"X0"};
X(1,2)              = {vSTARTVEKTOR};
iLAENGE_STARTVEKTOR = length(vSTARTVEKTOR);
BERECHNUNG(1,1)     = {"k"};
BERECHNUNG(1,2)     = {"A"};
BERECHNUNG(1,3)     = {"*Delta X"};
BERECHNUNG(1,4)     = {"=Ergebnis"};

%BERECHNUNG------------------------------------------------------------------------
%Bildung der Jacobi-Matrix Df
symDF=jacobian(symNLGS,vVARIABLEN);
Df = arrayfun(@char, symDF, 'uniform', 0);

%Berechnung Matrix A fr A*x=B
X0=cell2mat(X(1,2));
f(vVARIABLEN)=symDF;
switch iLAENGE_STARTVEKTOR
    case 1
        symSPEICHER=f(X0(1));
    case 2
        symSPEICHER=f(X0(1), X0(2));
    case 3
        symSPEICHER=f(X0(1), X0(2), X0(3));
    case 4
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4));
    case 5
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5));
    case 6
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6));
    case 7
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7));
    case 8
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8));
    case 9
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9));
    case 10
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10));
    case 11
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11));
    case 12
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12));
    case 13
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13));
    case 14
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13), X0(14));
    case 15
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13), X0(14), X0(15));
    case 16
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13), X0(14), X0(15), X0(16));
    case 17
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13), X0(14), X0(15), X0(16), X0(17));
    case 18
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13), X0(14), X0(15), X0(16), X0(17), X0(18));
    case 19
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13), X0(14), X0(15), X0(16), X0(17), X0(18), X0(19));
    case 20
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13), X0(14), X0(15), X0(16), X0(17), X0(18), X0(19), X0(20));
    case 21
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13), X0(14), X0(15), X0(16), X0(17), X0(18), X0(19), X0(20), X0(21));
    case 22
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13), X0(14), X0(15), X0(16), X0(17), X0(18), X0(19), X0(20), X0(21), X0(22));
    case 23
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13), X0(14), X0(15), X0(16), X0(17), X0(18), X0(19), X0(20), X0(21), X0(22), X0(23));
    case 24
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13), X0(14), X0(15), X0(16), X0(17), X0(18), X0(19), X0(20), X0(21), X0(22), X0(23), X0(24));
    case 25
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13), X0(14), X0(15), X0(16), X0(17), X0(18), X0(19), X0(20), X0(21), X0(22), X0(23), X0(24), X0(25));
    case 26
        symSPEICHER=f(X0(1), X0(2), X0(3), X0(4), X0(5), X0(6), X0(7), X0(8), X0(9), X0(10), X0(11), X0(12), X0(13), X0(14), X0(15), X0(16), X0(17), X0(18), X0(19), X0(20), X0(21), X0(22), X0(23), X0(24), X0(25), X0(26));
    otherwise
        disp("Ooops");
end
aA=cell2mat(arrayfun(@double, symSPEICHER, 'uniform', 0));
BERECHNUNG(2,2)={arrayfun(@char, symSPEICHER, 'uniform', 0)};

for(ii=1:1:ik)
    BERECHNUNG(ii+1,1)={ii-1};
    if(ii>1)    
        BERECHNUNG(ii+1,2)=BERECHNUNG(ii,2);
    end
        
    %Berechnung Matrix B fr A*x=B
    Xk=cell2mat(X(ii,2));
    f(vVARIABLEN)=symNLGS;
    switch iLAENGE_STARTVEKTOR
        case 1
            symSPEICHER=-f(Xk(1));
        case 2
            symSPEICHER=-f(Xk(1), Xk(2));
        case 3
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3));
        case 4
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4));
        case 5
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5));
        case 6
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6));
        case 7
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7));
        case 8
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8));
        case 9
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9));
        case 10
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10));
        case 11
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11));
        case 12
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12));
        case 13
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13));
        case 14
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13), Xk(14));
        case 15
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13), Xk(14), Xk(15));
        case 16
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13), Xk(14), Xk(15), Xk(16));
        case 17
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13), Xk(14), Xk(15), Xk(16), Xk(17));
        case 18
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13), Xk(14), Xk(15), Xk(16), Xk(17), Xk(18));
        case 19
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13), Xk(14), Xk(15), Xk(16), Xk(17), Xk(18), Xk(19));
        case 20
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13), Xk(14), Xk(15), Xk(16), Xk(17), Xk(18), Xk(19), Xk(20));
        case 21
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13), Xk(14), Xk(15), Xk(16), Xk(17), Xk(18), Xk(19), Xk(20), Xk(21));
        case 22
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13), Xk(14), Xk(15), Xk(16), Xk(17), Xk(18), Xk(19), Xk(20), Xk(21), Xk(22));
        case 23
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13), Xk(14), Xk(15), Xk(16), Xk(17), Xk(18), Xk(19), Xk(20), Xk(21), Xk(22), Xk(23));
        case 24
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13), Xk(14), Xk(15), Xk(16), Xk(17), Xk(18), Xk(19), Xk(20), Xk(21), Xk(22), Xk(23), Xk(24));
        case 25
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13), Xk(14), Xk(15), Xk(16), Xk(17), Xk(18), Xk(19), Xk(20), Xk(21), Xk(22), Xk(23), Xk(24), Xk(25));
        case 26
            symSPEICHER=-f(Xk(1), Xk(2), Xk(3), Xk(4), Xk(5), Xk(6), Xk(7), Xk(8), Xk(9), Xk(10), Xk(11), Xk(12), Xk(13), Xk(14), Xk(15), Xk(16), Xk(17), Xk(18), Xk(19), Xk(20), Xk(21), Xk(22), Xk(23), Xk(24), Xk(25), Xk(26));
        otherwise
            disp("Ooops");
    end
    aB=cell2mat(arrayfun(@double, symSPEICHER, 'uniform', 0));
    BERECHNUNG(ii+1,4)={arrayfun(@char, symSPEICHER, 'uniform', 0)};

    %Lsung des Linearen Gleichungssystems
    X(ii+1,1)={strcat("X",num2str(ii))};
    DELTA_X=Gauss_Verfahren(aA,aB);
    BERECHNUNG(ii+1,3)={DELTA_X};
    X(ii+1,2)={cell2mat(X(ii,2))+DELTA_X};
end
    
%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except NLGS Df X BERECHNUNG A                                       %Workspace aufrumen